/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.wrd;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ModConfig {
    public static final ForgeConfigSpec COMMON_CONFIG;
    private static final ForgeConfigSpec.Builder COMMON_BUILDER;
    public static final ForgeConfigSpec.IntValue CFDungeonSize;
    public static final ForgeConfigSpec.IntValue CFDungeonDifficulty;
    public static final ForgeConfigSpec.IntValue CFSlowerDungeonCounter;
    public static final ForgeConfigSpec.IntValue CFModifierChance;
    public static final ForgeConfigSpec.BooleanValue CFAllowModifiers;
    public static final ForgeConfigSpec.BooleanValue CFShowModifierNames;
    public static final ForgeConfigSpec.BooleanValue CFAllowVesselofVision;
    public static final ForgeConfigSpec.BooleanValue CFAllowNaturalDungeons;
    public static final ForgeConfigSpec.IntValue CFDungeonRarity;
    public static final ForgeConfigSpec.IntValue CFNetherDungeonRarity;

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_CONFIG, "wesleys-roguelike-dungeons-config.toml");
    }

    static {
        COMMON_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.comment("Wesley's Roguelike Dungeons Configurations").push("common");
        CFDungeonSize = COMMON_BUILDER.comment("Size of the dungeons, 0 = small | 1 = medium | 2 = large").defineInRange("CFDungeonSize", 1, 0, 2);
        CFDungeonDifficulty = COMMON_BUILDER.comment("Difficulty of the dungeons, 0 = easy | 1 = normal | 2 = hard").defineInRange("CFDungeonDifficulty", 1, 0, 2);
        CFModifierChance = COMMON_BUILDER.comment("Chance of mobs spawning with modifiers").defineInRange("CFModifierChance", 1, 0, 100);
        CFAllowModifiers = COMMON_BUILDER.comment("Allow for mobs to spawn with modifiers").define("CFAllowModifiers", true);
        CFSlowerDungeonCounter = COMMON_BUILDER.comment("If the dungeon dimension timer is too fast, you can slow it down here").defineInRange("CFSlowerDungeonCounter", 100, 0, 200);
        CFAllowVesselofVision = COMMON_BUILDER.comment("Allow for players to generate dungeons using Vessels of Vision").define("CFAllowVesselofVision", true);
        CFAllowNaturalDungeons = COMMON_BUILDER.comment("Allow for dungeons to randomly generate into the world").define("CFAllowNaturalDungeons", false);
        CFShowModifierNames = COMMON_BUILDER.comment("Allow mobs with modifiers to always show their name").define("CFShowModifierNames", true);
        CFDungeonRarity = COMMON_BUILDER.comment("Changes the rarity of naturally generated dungeons if enabled (amount of structures per 1.000.000 chunks)").defineInRange("CFDungeonRarity", 250, 0, 10000);
        CFNetherDungeonRarity = COMMON_BUILDER.comment("Changes the rarity of naturally generated nether dungeons if enabled (amount of structures per 1.000.000 chunks)").defineInRange("CFNetherDungeonRarity", 300, 0, 10000);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

